/*
 *  krt_symbols_sunos5.c,v 1.1 1993/04/01 22:54:02 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#define	INCLUDE_FILE
#define	INCLUDE_IOCTL
#include "include.h"
#ifdef	PROTO_INET
#include "inet.h"
#include <inet/nd.h>
#endif	/* PROTO_INET */
#include "krt.h"
#include "krt_var.h"
#include <sys/systeminfo.h>

static char *
krt_symbols_ndd __PF2(module, const char *,
		      name, const char *)
{
    int sd;
    int rc;
    static char buf[64];

    NON_INTR(sd, open(module, O_RDWR));
    if (sd == -1) {
	trace(TR_ALL, LOG_ERR, "krt_symbols_ndd: open %s: %m",
	      module);
	return (char *) 0;
    }

    strcpy(buf, name);

    rc = task_ioctl(sd,
		    ND_GET,
		    buf,
		    sizeof buf);
    if (rc == -1) {
	trace(TR_ALL, LOG_ERR, "krt_symbols_ndd: ioctl(ND_GET, %s): %m",
	      name);
	(void) close(sd);
	return (char *) 0;
    }

    (void) close(sd);
    return buf;
}


int
krt_symbols __PF0(void)
{
    char *resp;
    char buf[BUFSIZ], *bp = buf;
    int len = sizeof buf;
    static long infos[] = {
	SI_SYSNAME,
	SI_RELEASE,
	SI_VERSION,
	SI_HOSTNAME,
	SI_MACHINE,
	SI_ARCHITECTURE,
	0
    };
    long *info = infos;

#ifdef	PROTO_INET
    resp = krt_symbols_ndd("/dev/ip", "ip_forwarding");
    if (resp) {
	inet_ipforwarding = atoi(resp);
    }
    resp = krt_symbols_ndd("/dev/udp", "udp_do_checksum");
    if (resp) {
	inet_udpcksum = atoi(resp);
    }
#endif	/* PROTO_INET */

    do {
	int rc;
	
	*bp = (char) 0;
	rc = sysinfo(*info, bp, len);
	if (rc == -1) {
	    trace(TR_ALL, LOG_ERR, "krt_symbols: sysinfo(): %m");
	    continue;
	}
	bp += rc;
	len -= rc;
	bp[-1] = ' ';
    } while (*++info) ;
    *bp = (char) 0;

    krt_version_kernel = task_mem_strdup(krt_task, buf);

    trace(TR_KRT, 0, NULL);
    trace(TR_KRT, 0, "krt_symbols: krt_version_kernel = %s",
	  krt_version_kernel);

    return 0;
}
