/*
 *  rt_aggregate.c,v 1.1 1993/04/05 04:29:08 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#define	INCLUDE_RT_VAR

#include "include.h"
#include "parse.h"
#ifdef	PROTO_INET
#include "inet.h"
#endif	/* PROTO_INET */
#ifdef	PROTO_ISO
#include "iso.h"
#endif	/* PROTO_ISO */

/**/


/* Aggregate routes */


adv_entry *aggregate_list;		/* Aggregation policy */

static block_t rt_aggregate_block_index;

static gw_entry *rt_aggregate_gwp;

/* XXX */
#define	aspath_aggregate(list, rta, changed)	(as_path *) 0

/**/

static dest_mask *
aggregate __PF3(rt, rt_entry *,
		list, adv_entry *,
		preference, pref_t *)
{
    adv_entry *aggr;

    ADV_LIST(list, aggr) {

	if (sockaddrcmp_mask(rt->rt_dest,
			     aggr->adv_dm.dm_dest,
			     aggr->adv_dm.dm_mask)
	    && rt->rt_dest_mask != aggr->adv_dm.dm_mask
	    && mask_refines(rt->rt_dest_mask,
			    aggr->adv_dm.dm_mask)) {
	    /* Potential match */

	    adv_entry *proto;

	    ADV_LIST(aggr->adv_list, proto) {
		/* Check for a protocol match */

		if (proto->adv_proto == RTPROTO_ANY
		    || proto->adv_proto == rt->rt_gwp->gw_proto) {
		    adv_entry *adv;

		    /* Right protocol, check the list */

		    if (!proto->adv_list
			|| (adv = adv_destmask_match(proto->adv_list,
						 rt->rt_dest))) {

			/* Have a match, get preference */

			if ((adv
			     && BIT_TEST(adv->adv_flag, ADVF_NO))
			    || BIT_TEST(proto->adv_flag, ADVF_NO)
			    || BIT_TEST(aggr->adv_flag, ADVF_NO)) {

			    continue;
			} else {
			    if (adv
				&& BIT_TEST(adv->adv_flag, ADVFOT_PREFERENCE)) {
				*preference = adv->adv_result.res_preference;
			    } else if (BIT_TEST(proto->adv_flag, ADVFOT_PREFERENCE)) {
				*preference = proto->adv_result.res_preference;
			    } else if (BIT_TEST(aggr->adv_flag, ADVFOT_PREFERENCE)) {
				*preference = aggr->adv_result.res_preference;
			    } else {
				*preference = RTPREF_AGGREGATE;
			    }

			    return &aggr->adv_dm;
			}
		    }
		}
	    } ADV_LIST_END(aggr->adv_list, proto) ;
	}
    } ADV_LIST_END(list, aggr) ;

    return (dest_mask *) 0;
}


/**/
void
rt_aggregate_list_add __PF4(proto, proto_t,
			    dest, sockaddr_un *,
			    mask1, sockaddr_un *,
			    mask2, sockaddr_un *)
{
    adv_entry *adv;
    sockaddr_un *dest2 = sockdup(dest);

    sockmask(dest2, mask2);

    ADV_LIST(aggregate_list, adv) {
	if (sockaddrcmp(dest2, adv->adv_dm.dm_dest)
	    && mask2 == adv->adv_dm.dm_mask) {
	    /* Already exists */

	    sockfree(dest2);
	    return;
	}
    } ADV_LIST_END(aggregate_list, adv) ;

    adv = adv_alloc(ADVFT_DM, 0);
    adv->adv_dm.dm_dest = dest2;
    adv->adv_dm.dm_mask = mask2;
    adv->adv_list = adv_alloc(ADVFT_ANY|ADVF_FIRST, proto);
    adv->adv_list->adv_list = adv_alloc(ADVFT_DM, 0);
    adv->adv_list->adv_list->adv_dm.dm_dest = sockdup(dest);
    adv->adv_list->adv_list->adv_dm.dm_mask = mask1;

    aggregate_list = parse_adv_dm_append(aggregate_list, adv);
    if (!aggregate) {
	trace(TR_ALL, LOG_ERR, "rt_aggregate_list_add: %s",
	      parse_error);
	assert(FALSE);
    }
}
/**/

static void
rt_aggregate_list_update __PF3(rta_list, rt_aggr_entry *,
			       rt, rt_entry *,
			       preference, pref_t)
{
    register rt_aggr_entry *rta;

    if (!rt->rt_aggregate) {
	rt->rt_aggregate = (rt_aggr_entry *) task_block_alloc(rt_aggregate_block_index);
    }
    rt->rt_aggregate->rta_rt = rt;
    rt->rt_aggregate->rta_preference = preference;

    AGGR_LIST(rta_list, rta) {
	if (rta->rta_preference > preference) {
	    /* Insert before this one */

	    break;
	}
    } AGGR_LIST_END(rta_list, rta) ;

    insque((struct qelem *) rt->rt_aggregate,
	   (struct qelem *) rta->rta_back);
}


static void
rt_aggregate_locate __PF3(rt, rt_entry *,
			  dm, dest_mask *,
			  preference, pref_t)
{
    rt_entry *aggr_rt;
    
    aggr_rt = rt_locate(RTS_INTERIOR|RTS_AGGREGATE,
			dm->dm_dest,
			dm->dm_mask,
			RTPROTO_BIT(RTPROTO_AGGREGATE));
    if (aggr_rt) {
	/* Aggregate exists, update */

	rt_aggregate_list_update(rt_aggregate_entry(aggr_rt),
				 rt,
				 preference);
	rt->rt_aggregate->rta_aggr_rt = aggr_rt;
	aggr_rt = rt_change_aspath(aggr_rt,
				   aggr_rt->rt_metric,
				   aggr_rt->rt_tag,
				   preference,
				   0, (sockaddr_un **) 0,
#ifdef	ROUTE_AGGREGATION
				   aggr_rt->rt_aspath
#else	/* ROUTE_AGGREGATION */
				   aspath_aggregate(rt_aggregate_entry(aggr_rt),
						    rt->rt_aggregate,
						    FALSE)
#endif	/* ROUTE_AGGREGATION */
				   );
	assert(aggr_rt);
    } else {
	/* Aggregate does not exist, create */

	rt_parms rtparms;
	rt_aggr_entry *rta;

	bzero((caddr_t) &rtparms, sizeof (rtparms));

	rtparms.rtp_dest = dm->dm_dest;
	rtparms.rtp_dest_mask = dm->dm_mask;
	rtparms.rtp_n_gw = 0;		/* XXX - What does this break? */
	rtparms.rtp_gwp = rt_aggregate_gwp;
	rtparms.rtp_metric = (metric_t) 0;
	rtparms.rtp_tag = (metric_t) 0;
	rtparms.rtp_state = RTS_INTERIOR | RTS_AGGREGATE | RTS_REJECT | RTS_NOAGE;
	rtparms.rtp_preference = preference;

	/* Allocate rt_data info plus head of list */
	rtparms.rtp_rtd = rtd_alloc(sizeof (rt_aggr_entry));
	rtparms.rtp_rtd->rtd_refcount++;
	rtparms.rtp_rtd->rtd_data = (void_t) (rtparms.rtp_rtd + 1);
	rta = (rt_aggr_entry *) rtparms.rtp_rtd->rtd_data;
	rta->rta_forw = rta->rta_back = rta;
	rta->rta_brief = !BIT_MATCH(dm->dm_flags, DMF_EXACT);
	rt_aggregate_list_update(rta, rt, preference);
#ifdef	PROTO_ASPATHS
	rtparms.rtp_asp = aspath_aggregate(rta,
					   rt->rt_aggregate,
					   FALSE);
#endif	/* PROTO_ASPATHS */

	/* Now add it to the routing table */
	rta->rta_aggr_rt = rt->rt_aggregate->rta_aggr_rt = rt_add(&rtparms);
	assert(rta->rta_aggr_rt);
    }
}


void
rt_aggregate_delete __PF1(rt, rt_entry *)
{
    rt_entry *aggr_rt = rt->rt_aggregate->rta_aggr_rt;
    rt_aggr_entry *rta = rt_aggregate_entry(aggr_rt);

    remque((struct qelem *) rt->rt_aggregate);

    if (rta != rta->rta_forw) {
	/* Still have some entries */

	aggr_rt = rt_change_aspath(aggr_rt,
				   aggr_rt->rt_metric,
				   aggr_rt->rt_tag,
				   rta->rta_preference,
				   0, (sockaddr_un **) 0,
#ifdef	ROUTE_AGGREGATION
				   aggr_rt->rt_aspath
#else	/* ROUTE_AGGREGATION */
				   aspath_aggregate(rta,
						    rt->rt_aggregate,
						    FALSE)
#endif	/* ROUTE_AGGREGATION */
				   );
	assert(aggr_rt);
    } else {
	/* No more entries, delete aggregate */

	rt_delete(aggr_rt);
    }

    task_block_free(rt_aggregate_block_index, (void_t) rt->rt_aggregate);
    rt->rt_aggregate = (rt_aggr_entry *) 0;
}


void
rt_aggregate_add __PF1(rt, rt_entry *)
{
    dest_mask *dm;
    pref_t preference;

    dm = aggregate(rt, aggregate_list, &preference);
    if (dm) {
	rt_aggregate_locate(rt, dm, preference);
    }
}


void
rt_aggregate_change __PF1(rt, rt_entry *)
{
    dest_mask *dm;
    pref_t preference;

    dm = aggregate(rt, aggregate_list, &preference);
    if (!dm) {
	/* No aggregate for this route */

	if (rt->rt_aggregate) {
	    /* Delete existing aggregate */
	    
	    rt_aggregate_delete(rt);
	}

    } else if (rt->rt_aggregate) {
	/* Have an aggregate */

	rt_aggr_entry *rta = rt->rt_aggregate;
	
	if (sockaddrcmp(dm->dm_dest, rta->rta_aggr_rt->rt_dest)
	    && dm->dm_mask == rta->rta_aggr_rt->rt_dest_mask) {
	    /* Same aggregate, update */

	    rta->rta_aggr_rt = rt_change_aspath(rta->rta_aggr_rt,
						rta->rta_aggr_rt->rt_metric,
						rta->rta_aggr_rt->rt_tag,
						rta->rta_preference,
						0, (sockaddr_un **) 0,
#ifdef	ROUTE_AGGREGATION
						rta->rta_aggr_rt->rt_aspath
#else	/* ROUTE_AGGREGATION */
						aspath_aggregate(rt_aggregate_entry(rta->rta_aggr_rt),
								 rta,
								 TRUE)
#endif	/* ROUTE_AGGREGATION */
						);
	    assert(rta->rta_aggr_rt);
	} else {
	    /* Different aggregate, change */

	    /* Delete old one */
	    rt_aggregate_delete(rt);

	    rt_aggregate_locate(rt, dm, preference);
	}
    } else {
	/* No existing aggregate, create a new one */

	rt_aggregate_locate(rt, dm, preference);
    }
}


void
rt_aggregate_reinit __PF1(tp, task *)
{
    rt_list *rtl = rtlist_all(AF_UNSPEC);
    register rt_entry *rt;

    rt_open(tp);
    
    RT_LIST(rt, rtl, rt_entry) {
	/* Update this route */

	if (rt->rt_preference < 0) {
	    if (rt->rt_aggregate) {
		/* No longer valid to contribute to an aggregate */
		rt_aggregate_delete(rt);
	    }
	} else {
	    /* Existing aggregate */

	    rt_aggregate_change(rt);
	}
    } RT_LIST_END(rt, rtl, rt_entry) ;

    rt_close(tp, (gw_entry *) 0, 0, NULL);
}


void
rt_aggregate_cleanup __PF1(tp, task *)
{
    if (aggregate_list) {
	adv_free_list(aggregate_list);
	aggregate_list = (adv_entry *) 0;
    }
}


/**/

void
rt_aggregate_dump __PF1(fp, FILE *)
{
    adv_entry *aggr;

    if (aggregate_list) {
	(void) fprintf(fp, "\tAggregation policy:\n\n");
    }
    
    ADV_LIST(aggregate_list, aggr) {
	adv_entry *proto;

	(void) fprintf(fp, "\t\t%A/%A",
		       aggr->adv_dm.dm_dest,
		       aggr->adv_dm.dm_mask);
	if (!BIT_TEST(aggr->adv_dm.dm_flags, DMF_EXACT)) {
	    (void) fprintf(fp, " brief");
	}
	if (BIT_TEST(aggr->adv_flag, ADVF_NO)) {
	    (void) fprintf(fp,
			   " restrict\n");
	} else if (BIT_TEST(aggr->adv_flag, ADVFOT_PREFERENCE)) {
	    (void) fprintf(fp,
			   " preference %d\n",
			   aggr->adv_result.res_preference);
	} else {
	    (void) fprintf(fp, "\n");
	}

	ADV_LIST(aggr->adv_list, proto) {
	    (void) fprintf(fp, "\t\t\tproto %s",
			   trace_state(rt_proto_bits, proto->adv_proto));

	    if (BIT_TEST(proto->adv_flag, ADVF_NO)) {
		(void) fprintf(fp,
			       " restrict\n");
	    } else if (BIT_TEST(proto->adv_flag, ADVFOT_PREFERENCE)) {
		(void) fprintf(fp,
			       " preference %d\n",
			       proto->adv_result.res_preference);
	    } else {
		(void) fprintf(fp, "\n");
	    }

	    control_dmlist_dump(fp,
				4,
				proto->adv_list,
				(adv_entry *) 0,
				(adv_entry *) 0);

	} ADV_LIST_END(aggr->adv_list, proto) ;
	
    } ADV_LIST_END(aggregate_list, aggr) ;
    fprintf(fp, "\n");
}


void
rt_aggregate_dump_rt __PF2(fp, FILE *,
			   rt, rt_entry *)
{
    if (rt->rt_aggregate) {
	rt_entry *aggr_rt = rt->rt_aggregate->rta_aggr_rt;
		
	(void) fprintf(fp,
		       "\t\t\tAggregate: %A mask %A metric %u preference %d\n",
		       aggr_rt->rt_dest,
		       aggr_rt->rt_dest_mask,
		       aggr_rt->rt_metric,
		       aggr_rt->rt_preference);
    }

    if (BIT_TEST(rt->rt_state, RTS_AGGREGATE)) {
	rt_aggr_entry *rta;

	(void) fprintf(fp,
		       "\t\t\tAggregate Routes:\n");

	AGGR_LIST(rt_aggregate_entry(rt), rta) {
	    fprintf(fp,
		    "\t\t\t\t%A mask %A metric %d preference %d\n",
		    rta->rta_rt->rt_dest,
		    rta->rta_rt->rt_dest_mask,
		    rta->rta_rt->rt_metric,
		    rta->rta_rt->rt_preference);
	} AGGR_LIST_END(rt_aggregate_entry(rt), rta);
    }
}

/**/

void
rt_aggregate_init __PF1(tp, task *)
{
    rt_aggregate_gwp = gw_init((gw_entry *) 0,
			       RTPROTO_AGGREGATE,
			       tp,
			       (as_t) 0,
			       (as_t) 0,
			       (time_t) 0,
			       (sockaddr_un *) 0,
			       (flag_t) 0);

    rt_aggregate_block_index = task_block_init(sizeof (rt_aggr_entry));
}
