// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/socket.h>
#include <giomm/private/socket_p.h>


/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/error.h>
#include <giomm/asyncresult.h>
#include <giomm/socketsource.h>
#include <giomm/slot_async.h>

using Type = Gio::Socket::Type;
using Protocol = Gio::Socket::Protocol;

namespace Gio
{

Socket::Socket(SocketFamily family, Type type, Protocol protocol,
  const Glib::RefPtr<Cancellable>& cancellable)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(socket_class_.init(), "family",int(family),"type",int(type),"protocol",int(protocol), nullptr))
{
  init(cancellable);
}

Socket::Socket(int fd, const Glib::RefPtr<Cancellable>& cancellable) : // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(socket_class_.init(), "fd",fd, nullptr))
{
  init(cancellable);
}

// static
Glib::RefPtr<Socket>
Socket::create(SocketFamily family, Type type, Protocol protocol,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  return Glib::make_refptr_for_instance<Socket>(new Socket(family, type, protocol, cancellable));
}

// static
Glib::RefPtr<Socket>
Socket::create_from_fd(int fd, const Glib::RefPtr<Cancellable>& cancellable)
{
  return Glib::make_refptr_for_instance<Socket>(new Socket(fd, cancellable));
}

gssize
Socket::receive_from(Glib::RefPtr<SocketAddress>& address, char* buffer, gsize size,
  const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  GSocketAddress* caddr = nullptr;
  auto retvalue = g_socket_receive_from(
    gobj(), &caddr, buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (caddr)
    address = Glib::wrap(caddr);

  return retvalue;
}

gssize
Socket::receive_from(Glib::RefPtr<SocketAddress>& address, char* buffer, gsize size)
{
  GError* gerror = nullptr;
  GSocketAddress* caddr = nullptr;
  auto retvalue = g_socket_receive_from(gobj(), &caddr, buffer, size, nullptr, &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  if (caddr)
    address = Glib::wrap(caddr);

  return retvalue;
}

gssize
Socket::receive_with_blocking(
  gchar* buffer, gsize size, bool blocking, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  const auto retvalue = g_socket_receive_with_blocking(
    gobj(), buffer, size, blocking, Glib::unwrap(cancellable), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

gssize
Socket::send_with_blocking(
  gchar* buffer, gsize size, bool blocking, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  const auto retvalue = g_socket_send_with_blocking(
    gobj(), buffer, size, blocking, Glib::unwrap(cancellable), &(gerror));
  if (gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<SocketSource>
Socket::create_source(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable)
{
  return SocketSource::create(gobj(), condition, cancellable);
}

} // namespace Gio

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gio::Socket::Type>::value_type()
{
  return g_socket_type_get_type();
}

// static
GType Glib::Value<Gio::Socket::Protocol>::value_type()
{
  return g_socket_protocol_get_type();
}

// static
GType Glib::Value<Gio::Socket::MsgFlags>::value_type()
{
  return g_socket_msg_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::Socket> wrap(GSocket* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::Socket>( dynamic_cast<Gio::Socket*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Socket_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Socket_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_socket_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Initable::add_interface(get_type());

  }

  return *this;
}


void Socket_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Socket_Class::wrap_new(GObject* object)
{
  return new Socket((GSocket*)object);
}


/* The implementation: */

GSocket* Socket::gobj_copy()
{
  reference();
  return gobj();
}

Socket::Socket(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Socket::Socket(GSocket* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Socket::Socket(Socket&& src) noexcept
: Glib::Object(std::move(src))
  , Initable(std::move(src))
{}

Socket& Socket::operator=(Socket&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  Initable::operator=(std::move(src));
  return *this;
}


Socket::~Socket() noexcept
{}


Socket::CppClassType Socket::socket_class_; // initialize static member

GType Socket::get_type()
{
  return socket_class_.init().get_type();
}


GType Socket::get_base_type()
{
  return g_socket_get_type();
}


void Socket::bind(const Glib::RefPtr<SocketAddress>& address, bool allow_reuse)
{
  GError* gerror = nullptr;
  g_socket_bind(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), static_cast<int>(allow_reuse), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::listen()
{
  GError* gerror = nullptr;
  g_socket_listen(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

Glib::RefPtr<Socket> Socket::accept(const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_accept(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Socket> Socket::accept()
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_accept(gobj(), nullptr, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Socket::connect(const Glib::RefPtr<SocketAddress>& address, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  g_socket_connect(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::connect(const Glib::RefPtr<SocketAddress>& address)
{
  GError* gerror = nullptr;
  g_socket_connect(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::check_connect_result()
{
  GError* gerror = nullptr;
  g_socket_check_connect_result(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

gssize Socket::receive(char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_receive(gobj(), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::receive(char* buffer, gsize size)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_receive(gobj(), buffer, size, nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Glib::Bytes> Socket::receive_bytes(gsize size, gint64 timeout_us, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_receive_bytes(gobj(), size, timeout_us, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Glib::Bytes> Socket::receive_bytes_from(Glib::RefPtr<SocketAddress>& address, gsize size, gint64 timeout_us, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  GSocketAddress* g_address = nullptr;
  auto retvalue = Glib::wrap(g_socket_receive_bytes_from(gobj(), &g_address, size, timeout_us, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
if (g_address) address = Glib::wrap(g_address);
  return retvalue;
}

gssize Socket::send(const gchar* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_send(gobj(), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send(const gchar* buffer, gsize size)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_send(gobj(), buffer, size, nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_send_to(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), buffer, size, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

gssize Socket::send_to(const Glib::RefPtr<SocketAddress>& address, const char* buffer, gsize size)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_send_to(gobj(), const_cast<GSocketAddress*>(Glib::unwrap(address)), buffer, size, nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Socket::close()
{
  GError* gerror = nullptr;
  g_socket_close(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Socket::is_closed()
{
  return g_socket_is_closed(gobj());
}

void Socket::shutdown(bool shutdown_read, bool shutdown_write)
{
  GError* gerror = nullptr;
  g_socket_shutdown(gobj(), static_cast<int>(shutdown_read), static_cast<int>(shutdown_write), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

bool Socket::is_connected()
{
  return g_socket_is_connected(gobj());
}

gssize Socket::get_available_bytes() const
{
  return g_socket_get_available_bytes(const_cast<GSocket*>(gobj()));
}

Glib::IOCondition Socket::condition_check(Glib::IOCondition condition)
{
  return static_cast<Glib::IOCondition>(g_socket_condition_check(gobj(), static_cast<GIOCondition>(condition)));
}

void Socket::condition_wait(Glib::IOCondition condition, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  g_socket_condition_wait(gobj(), static_cast<GIOCondition>(condition), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_wait(Glib::IOCondition condition)
{
  GError* gerror = nullptr;
  g_socket_condition_wait(gobj(), static_cast<GIOCondition>(condition), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_timed_wait(Glib::IOCondition condition, gint64 timeout, const Glib::RefPtr<Cancellable>& cancellable)
{
  GError* gerror = nullptr;
  g_socket_condition_timed_wait(gobj(), static_cast<GIOCondition>(condition), timeout, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::condition_timed_wait(Glib::IOCondition condition, gint64 timeout)
{
  GError* gerror = nullptr;
  g_socket_condition_timed_wait(gobj(), static_cast<GIOCondition>(condition), timeout, nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
}

void Socket::set_listen_backlog(int backlog)
{
  g_socket_set_listen_backlog(gobj(), backlog);
}

int Socket::get_listen_backlog() const
{
  return g_socket_get_listen_backlog(const_cast<GSocket*>(gobj()));
}

void Socket::set_blocking(bool blocking)
{
  g_socket_set_blocking(gobj(), static_cast<int>(blocking));
}

bool Socket::get_blocking() const
{
  return g_socket_get_blocking(const_cast<GSocket*>(gobj()));
}

void Socket::set_keepalive(bool keepalive)
{
  g_socket_set_keepalive(gobj(), static_cast<int>(keepalive));
}

bool Socket::get_keepalive() const
{
  return g_socket_get_keepalive(const_cast<GSocket*>(gobj()));
}

SocketFamily Socket::get_family() const
{
  return static_cast<SocketFamily>(g_socket_get_family(const_cast<GSocket*>(gobj())));
}

int Socket::get_fd() const
{
  return g_socket_get_fd(const_cast<GSocket*>(gobj()));
}

Glib::RefPtr<SocketAddress> Socket::get_local_address() const
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_get_local_address(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<SocketAddress> Socket::get_remote_address() const
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_get_remote_address(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Protocol Socket::get_protocol() const
{
  return static_cast<Protocol>(g_socket_get_protocol(const_cast<GSocket*>(gobj())));
}

Type Socket::get_socket_type() const
{
  return static_cast<Type>(g_socket_get_socket_type(const_cast<GSocket*>(gobj())));
}

bool Socket::speaks_ipv4() const
{
  return g_socket_speaks_ipv4(const_cast<GSocket*>(gobj()));
}

Glib::RefPtr<Credentials> Socket::get_credentials()
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_get_credentials(gobj(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<const Credentials> Socket::get_credentials() const
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(g_socket_get_credentials(const_cast<GSocket*>(gobj()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

guint Socket::get_timeout() const
{
  return g_socket_get_timeout(const_cast<GSocket*>(gobj()));
}

void Socket::set_timeout(guint timeout)
{
  g_socket_set_timeout(gobj(), timeout);
}

bool Socket::get_option(int level, int optname, int& value) const
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_get_option(const_cast<GSocket*>(gobj()), level, optname, &(value), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::set_option(int level, int optname, int value)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_set_option(gobj(), level, optname, value, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

guint Socket::get_ttl() const
{
  return g_socket_get_ttl(const_cast<GSocket*>(gobj()));
}

void Socket::set_ttl(guint ttl)
{
  g_socket_set_ttl(gobj(), ttl);
}

bool Socket::get_broadcast() const
{
  return g_socket_get_broadcast(const_cast<GSocket*>(gobj()));
}

void Socket::set_broadcast(bool broadcast)
{
  g_socket_set_broadcast(gobj(), static_cast<int>(broadcast));
}

bool Socket::get_multicast_loopback() const
{
  return g_socket_get_multicast_loopback(const_cast<GSocket*>(gobj()));
}

void Socket::set_multicast_loopback(bool loopback)
{
  g_socket_set_multicast_loopback(gobj(), static_cast<int>(loopback));
}

guint Socket::get_multicast_ttl() const
{
  return g_socket_get_multicast_ttl(const_cast<GSocket*>(gobj()));
}

void Socket::set_multicast_ttl(guint ttl)
{
  g_socket_set_multicast_ttl(gobj(), ttl);
}

bool Socket::join_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific, const std::string& iface)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_join_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), iface.empty() ? nullptr : iface.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::join_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_join_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::leave_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific, const std::string& iface)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_leave_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), iface.empty() ? nullptr : iface.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Socket::leave_multicast_group(const Glib::RefPtr<InetAddress>& group, bool source_specific)
{
  GError* gerror = nullptr;
  auto retvalue = g_socket_leave_multicast_group(gobj(), const_cast<GInetAddress*>(Glib::unwrap(group)), static_cast<int>(source_specific), nullptr, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}


Glib::PropertyProxy< bool > Socket::property_blocking() 
{
  return Glib::PropertyProxy< bool >(this, "blocking");
}

Glib::PropertyProxy_ReadOnly< bool > Socket::property_blocking() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "blocking");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<SocketFamily>::value,
  "Type SocketFamily cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< SocketFamily > Socket::property_family() const
{
  return Glib::PropertyProxy_ReadOnly< SocketFamily >(this, "family");
}

Glib::PropertyProxy_ReadOnly< int > Socket::property_fd() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "fd");
}

Glib::PropertyProxy< bool > Socket::property_keepalive() 
{
  return Glib::PropertyProxy< bool >(this, "keepalive");
}

Glib::PropertyProxy_ReadOnly< bool > Socket::property_keepalive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "keepalive");
}

Glib::PropertyProxy< int > Socket::property_listen_backlog() 
{
  return Glib::PropertyProxy< int >(this, "listen-backlog");
}

Glib::PropertyProxy_ReadOnly< int > Socket::property_listen_backlog() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "listen-backlog");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<SocketAddress>>::value,
  "Type Glib::RefPtr<SocketAddress> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_local_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "local-address");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<SocketAddress>>::value,
  "Type Glib::RefPtr<SocketAddress> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> > Socket::property_remote_address() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketAddress> >(this, "remote-address");
}

Glib::PropertyProxy< guint > Socket::property_timeout() 
{
  return Glib::PropertyProxy< guint >(this, "timeout");
}

Glib::PropertyProxy_ReadOnly< guint > Socket::property_timeout() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "timeout");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Protocol>::value,
  "Type Protocol cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Protocol > Socket::property_protocol() const
{
  return Glib::PropertyProxy_ReadOnly< Protocol >(this, "protocol");
}

Glib::PropertyProxy< bool > Socket::property_broadcast() 
{
  return Glib::PropertyProxy< bool >(this, "broadcast");
}

Glib::PropertyProxy_ReadOnly< bool > Socket::property_broadcast() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "broadcast");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Type>::value,
  "Type Type cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Type > Socket::property_type() const
{
  return Glib::PropertyProxy_ReadOnly< Type >(this, "type");
}

Glib::PropertyProxy< guint > Socket::property_ttl() 
{
  return Glib::PropertyProxy< guint >(this, "ttl");
}

Glib::PropertyProxy_ReadOnly< guint > Socket::property_ttl() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "ttl");
}

Glib::PropertyProxy< bool > Socket::property_multicast_loopback() 
{
  return Glib::PropertyProxy< bool >(this, "multicast-loopback");
}

Glib::PropertyProxy_ReadOnly< bool > Socket::property_multicast_loopback() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "multicast-loopback");
}

Glib::PropertyProxy< guint > Socket::property_multicast_ttl() 
{
  return Glib::PropertyProxy< guint >(this, "multicast-ttl");
}

Glib::PropertyProxy_ReadOnly< guint > Socket::property_multicast_ttl() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "multicast-ttl");
}


} // namespace Gio


